﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.Windows.Forms;
using System.Runtime.InteropServices;


namespace ct.Asteroid
{
    public class Player
    {
        Socket mySocket; IPAddress server_ip;

        public bool ÜbertragungOK = false;
        public double Sekunden=0; public int loop = 0;
        public double ms_alt=0, ms=0;

        public Player(Socket sock, IPAddress server)
        {
            mySocket = sock;
            server_ip = server;
        }

        // Get a handle to an application window.
        [DllImport("USER32.DLL")]
        public static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

        // Activate an application window.
        [DllImport("USER32.DLL")]
        public static extern bool SetForegroundWindow(IntPtr hWnd);

        public void Run()
        {
            FramePacket frame = new FramePacket(); KeysPacket keys = new KeysPacket(); GameStatus game = new GameStatus(); game.clear();           // Initalisierung  
            char prevframe = (char)0; int Punkte = 0; int nasteroids_old = 0;

            ms = System.DateTime.UtcNow.Ticks / 10000; ms_alt = ms;

            game.clear(); Ausgabe_Init(game);

            for (; ; )
            {
                ms = System.DateTime.UtcNow.Ticks / 10000;  

                if ((game.Schiffe == 0) || ((ms - ms_alt) > 100)) { SendPacketName(keys); Thread.Sleep(1); SendPacket(keys); ms_alt = System.DateTime.UtcNow.Ticks / 10000; } // spätestens nach 100ms ein Thread.Sleep(1) usw.

                Ausgabe_immer(game);

                if (loop == 0) ++keys.ping; if (keys.ping > 255) keys.ping = (char)0;   // jedes gesendete Päckchen erhält eine individuelle Nummer zur Latenzmessung                           

                if (1 == 0)             
                {
                    frame = ReceivePacket(); if ((frame != null)) { for (int s = 0; s < 1; s++) SendPacket(keys); };    // zuerst Empfangen und wenn Paket erhalten Senden ... Latenz >= 1 möglich
                }
                else
                {
                    if (loop == 0) for (int s = 0; s < 1; s++) SendPacket(keys); frame = ReceivePacket();               // zuerst Senden und dann Empfangen ... Latenz==0 möglich 
                }

                // Thread.Sleep(1); !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

                if (frame == null) { loop++; continue; }
                if ((frame.vectorram[0] == (byte)'g') && (frame.vectorram[1] == (byte)'a') && (frame.vectorram[2] == (byte)'m') && (frame.vectorram[3] == (byte)'e')) { game.game_over = true; game.Schiffe = 0; loop++; continue; }
                if ((frame.vectorram[0] == (byte)'b') && (frame.vectorram[1] == (byte)'u') && (frame.vectorram[2] == (byte)'s') && (frame.vectorram[3] == (byte)'y')) { game.busy = true; game.Schiffe = 0; loop++; continue; }

                ms_alt = System.DateTime.UtcNow.Ticks / 10000; game.run = true;

                keys.clear();                       // alle Tasten loslassen

                game.Latenz = 0; game.Frames = 0;
                if (frame.frameno != ++prevframe || frame.ping != keys.ping) {game.Latenz = keys.ping - frame.ping;game.Frames = frame.frameno - prevframe;prevframe = frame.frameno;}

                if (game.Frames < -128) game.Frames = game.Frames + 256; if ((game.Frames > 99) || (game.Frames < -99)) game.Frames = 0;
                if (game.Latenz < -128) game.Latenz = game.Latenz + 256; if ((game.Latenz > 99) || (game.Latenz < -99)) game.Latenz = 0; 

                game.LostFrames = game.LostFrames + game.Frames;

                if ((game.Schiffe == 0) && (game.nasteroids > 0)) { game.clear(); Ausgabe_Init(game); }

                Punkte = game.Punkte;

                InterpretScreen(frame, game);       // Screen Daten auswerten
                game.calc();                        // Berechnungen durchführen

                if ((Punkte > game.Punkte) && ((game.Ticks / 10000000) > 100)) game.HTPunkte = game.HTPunkte + 1;
                if (game.Schiffe > 0) { game.Ticks = System.DateTime.UtcNow.Ticks - game.TicksStart; Sekunden = game.Ticks / 10000000; game.AnzFrames=game.AnzFrames+1+game.Frames; }
                if ((game.Punkte == 0) && (game.Schiffe == 3) && (game.ship_present == false)) { game.TicksStart = System.DateTime.UtcNow.Ticks; game.clear(); Ausgabe_Init(game); }

                int SyncP = 0, SyncM = 0;
                double Abweichung_W = 0;  double AbweichungP_W = 0; double AbweichungM_W = 0;
                
                game.calc_sync(frame.ping, keys.ping,frame.frameno);
                
                if (game.ship_present)
                {
                    if ((nasteroids_old > 0) && (game.nasteroids == 0)) Ausgabe_Runde(game); nasteroids_old = game.nasteroids;

                    int MinAbweichungZ = 2000;
                    int MinAbstand = 2000;


                    //game.calc_Schussabweichungen(game.SSync, game.Latenz);

                    game.calc_Schussabweichungen(game.SSync, game.DLatenz - 0.5);

                    game.calc_Schusstrefferwahrscheinlichkeit();
                    game.calc_Reihenfolge_Asteroids(game.SSync);
                    game.calc_Reihenfolge_UFO(game.SSync);

                    for (int i = 0; i < game.nasteroids; i++) // Überprüfung ob es ein gelocktes Ziel gibt und ev. Lock entfernen;
                    {
                        if (game.asteroids[i].Ziel_Lock > 0)
                        {
                            if ((game.nshots_eigen >= 4) || (game.asteroids[i].AbweichungZ > 72) || (game.saucer_present == true)) // keine Schüsse frei, ausser Reichweite oder Ufo dann Lock entfernen
                            {
                                game.asteroids[i].Ziel_Lock = 0;
                            }
                            else
                            {
                                if ((game.asteroids[i].sf == 0) && (game.asteroids[i].Schuss1 >= 0) && (game.asteroids[i].Schuss2 >= 0) && (game.asteroids[i].Schuss3 >= 0) && (game.asteroids[i].Schuss4 >= 0)) game.asteroids[i].Ziel_Lock = 0;
                                if ((game.asteroids[i].sf == 15) && (game.asteroids[i].Schuss1 >= 0) && (game.asteroids[i].Schuss2 >= 0) && (game.asteroids[i].Schuss3 >= 0)) game.asteroids[i].Ziel_Lock = 0;
                                if (game.asteroids[i].sf == 14) game.asteroids[i].Ziel_Lock = 0;
                            }
                        }
                    }

                    if (game.nshots_eigen < 4)  // Wenn Schüsse frei nähestes Object (Anzahl Schusszyklen) im Schussbereich ermitteln --> Freigabe Schuss wenn erfolgreich
                    {
                        for (int i = 0; i < game.nasteroids; i++)
                        {
//                            if (((game.asteroids[i].ok > 4)||((game.asteroids[i].ok>3) && (game.asteroids[i].AbweichungZ < 25)))  && (game.asteroids[i].AbweichungZ <= 72) && (game.asteroids[i].AbweichungW < (game.Winkel(game.asteroids[i].RadiusS, game.asteroids[i].AbstandMM))) && (game.asteroids[i].AbweichungW > -(game.Winkel(game.asteroids[i].RadiusS, game.asteroids[i].AbstandMM))))
                            if (((game.asteroids[i].ok == 5) || 
                                ((game.asteroids[i].ok == 4) && (game.asteroids[i].sf==0) && (game.asteroids[i].AbweichungZ < 60)) ||
                                ((game.asteroids[i].ok == 4) && (game.asteroids[i].sf==15) && (game.asteroids[i].AbweichungZ < 40)) ||
                                ((game.asteroids[i].ok == 4) && (game.asteroids[i].sf==14) && (game.asteroids[i].AbweichungZ < 20)) ||
                                ((game.asteroids[i].ok == 3) && (game.asteroids[i].sf == 0) && (game.asteroids[i].AbweichungZ < 30)) ||
                                ((game.asteroids[i].ok == 3) && (game.asteroids[i].sf == 15) && (game.asteroids[i].AbweichungZ < 20)) ||
                                ((game.asteroids[i].ok == 3) && (game.asteroids[i].sf == 14) && (game.asteroids[i].AbweichungZ < 10)) ||
                                ((game.asteroids[i].ok == 2) && (game.asteroids[i].sf == 0) && (game.asteroids[i].AbweichungZ < 15)) ||
                                ((game.asteroids[i].ok == 2) && (game.asteroids[i].sf == 15) && (game.asteroids[i].AbweichungZ < 10)) ||
                                ((game.asteroids[i].ok == 2) && (game.asteroids[i].sf == 14) && (game.asteroids[i].AbweichungZ < 5)) ||
                                ((game.asteroids[i].ok < 2) && (game.asteroids[i].sf == 0) && (game.asteroids[i].AbweichungZ < 7)) ||
                                ((game.asteroids[i].ok < 2) && (game.asteroids[i].sf == 15) && (game.asteroids[i].AbweichungZ < 5)) ||
                                ((game.asteroids[i].ok < 2) && (game.asteroids[i].sf == 14) && (game.asteroids[i].AbweichungZ < 3))
                                )
                                && (game.asteroids[i].AbweichungZ <= 72) && (game.asteroids[i].AbweichungW < (game.Winkel(game.asteroids[i].RadiusS, game.asteroids[i].AbstandMM))) && (game.asteroids[i].AbweichungW > -(game.Winkel(game.asteroids[i].RadiusS, game.asteroids[i].AbstandMM))))
                            {
                                if (game.asteroids[i].AbweichungZ < MinAbweichungZ)
                                {
                                    if ((game.asteroids[i].sf == 0) &&  (game.calc_Treffer(i) < 4) && ((game.asteroids[i].Schuss1 < 0) || (game.asteroids[i].Schuss2 < 0) || (game.asteroids[i].Schuss3 < 0) || (game.asteroids[i].Schuss4 < 0))) { game.ZielSchuss = i; MinAbweichungZ = game.asteroids[i].AbweichungZ; }
                                    if ((game.asteroids[i].sf == 15) && (game.calc_Treffer(i) < 3) && ((game.asteroids[i].Schuss1 < 0) || (game.asteroids[i].Schuss2 < 0) || (game.asteroids[i].Schuss3 < 0))) { game.ZielSchuss = i; MinAbweichungZ = game.asteroids[i].AbweichungZ; }
                                    if ((game.asteroids[i].sf == 14) && (game.calc_Treffer(i)== 0) && (game.asteroids[i].Schuss1 < 0)) { game.ZielSchuss = i; MinAbweichungZ = game.asteroids[i].AbweichungZ; }
                                }
                            }
                        }
                        if ((game.saucer_present) && (game.calc_Treffer(-2) == 0) && (game.saucer.Schuss < 0) && (game.saucer.AbweichungZ < MinAbweichungZ) && (game.saucer.AbweichungW < (game.Winkel(game.saucer.RadiusS, game.saucer.AbstandMM))) && (game.saucer.AbweichungW > -(game.Winkel(game.saucer.RadiusS, game.saucer.AbstandMM)))) { game.ZielSchuss = -2; MinAbweichungZ = game.saucer.AbweichungZ; }
                    }

                  
                    for (int i = 0; i < game.nasteroids; i++) // game.ZielDrehung ermitteln
                    {
                        if (game.asteroids[i].danger < MinAbstand)
                        {
                         // if ((game.asteroids[i].sf == 0) && ((game.calc_Treffer(i) < 1) || (game.asteroids[i].Ziel_Lock>0)) && ((game.asteroids[i].Schuss1 < 0) || (game.asteroids[i].Schuss2 < 0) || (game.asteroids[i].Schuss3 < 0) || (game.asteroids[i].Schuss4 < 0))) { MinAbstand = game.asteroids[i].danger; game.ZielDrehung = i;}
                         // if ((game.asteroids[i].sf == 15) && (game.calc_Treffer(i) < 1) && ((game.asteroids[i].Schuss1 < 0) || (game.asteroids[i].Schuss2 < 0) || (game.asteroids[i].Schuss3 < 0))) { MinAbstand = game.asteroids[i].danger; game.ZielDrehung = i; }
                         // if ((game.asteroids[i].sf == 14) && (game.calc_Treffer(i) < 1) && ((game.asteroids[i].Schuss1 < 0))) { MinAbstand = game.asteroids[i].danger; game.ZielDrehung = i; }

                            if ((game.asteroids[i].sf == 0) && ((game.calc_Treffer(i) < 1) || (game.asteroids[i].Ziel_Lock>0)) && ((game.asteroids[i].Schuss1 < 0) || (game.asteroids[i].Schuss2 < 0) || (game.asteroids[i].Schuss3 < 0) || (game.asteroids[i].Schuss4 < 0))) { MinAbstand = game.asteroids[i].danger; game.ZielDrehung = i; }
                            if ((game.asteroids[i].sf == 15)&& ((game.calc_Treffer(i) < 1) || (game.asteroids[i].Ziel_Lock>0)) && ((game.asteroids[i].Schuss1 < 0) || (game.asteroids[i].Schuss2 < 0) || (game.asteroids[i].Schuss3 < 0))) { MinAbstand = game.asteroids[i].danger; game.ZielDrehung = i; }
                            if ((game.asteroids[i].sf == 14) && (game.calc_Treffer(i) < 1) && ((game.asteroids[i].Schuss1 < 0))) { MinAbstand = game.asteroids[i].danger; game.ZielDrehung = i; }

                        }
                    }
                

                    if ((game.asteroids[game.ZielDrehung].sf == 0) && (game.calc_Treffer(game.ZielDrehung) < 1) && ((game.asteroids[game.ZielDrehung].Schuss1 < 0) || (game.asteroids[game.ZielDrehung].Schuss2 < 0) || (game.asteroids[game.ZielDrehung].Schuss3 < 0) || (game.asteroids[game.ZielDrehung].Schuss4 < 0))) 
                        // { game.asteroids[game.ZielDrehung].Ziel_Lock = 2; } // Ziel für 2 weitere Frames locken -> ev. 4 Schuss ermöglichen
                    { game.asteroids[game.ZielDrehung].Ziel_Lock = 4 + (int)Math.Round(game.DLatenz); } // Ziel für 2 weitere Frames locken -> ev. 4 Schuss ermöglichen

                    if ((game.asteroids[game.ZielDrehung].sf == 15) && (game.calc_Treffer(game.ZielDrehung) < 1) && ((game.asteroids[game.ZielDrehung].Schuss1 < 0) || (game.asteroids[game.ZielDrehung].Schuss2 < 0) || (game.asteroids[game.ZielDrehung].Schuss3 < 0) || (game.asteroids[game.ZielDrehung].Schuss4 < 0)))
                    // { game.asteroids[game.ZielDrehung].Ziel_Lock = 2; } // Ziel für 2 weitere Frames locken -> ev. 4 Schuss ermöglichen
                    { game.asteroids[game.ZielDrehung].Ziel_Lock = 2 + (int)Math.Round(game.DLatenz); } // Ziel für 2 weitere Frames locken -> ev. 4 Schuss ermöglichen


                    //if (game.saucer_present && (game.saucer.Schuss < 0) && (game.calc_Treffer(-2) == 0) && ((game.saucer.danger-(game.Runde*10))<MinAbstand))  
                    if (game.saucer_present && (game.saucer.Schuss < 0) && (game.calc_Treffer(-2) == 0) && (game.ZielDrehung==99)) { game.ZielDrehung = -2;} // UFO als Ziel
                    if (game.saucer_present && (game.saucer.Schuss < 0) && (game.calc_Treffer(-2) == 0) && (game.saucer_size==14)) { game.ZielDrehung = -2;} // UFO als Ziel

                    if ((game.ZielSchuss != game.ZielDrehung)&& (game.ZielAsteroidSF(game.ZielDrehung)>=0)&& (game.ZielAsteroidSF(game.ZielSchuss)>=0)) // Schüsse für optimales Ziel aufheben
                    {
                        // if ((game.ZielAsteroidSF(game.ZielDrehung) ==  0) && (game.SchüsseFrei(game.asteroids[game.ZielDrehung].ZDrehung + 2) < 2) && (game.asteroids[game.ZielSchuss].ZSumme > (game.asteroids[game.ZielDrehung].ZDrehung) + 2)) game.ZielSchuss = 99;
                        // if ((game.ZielAsteroidSF(game.ZielDrehung) == 15) && (game.SchüsseFrei(game.asteroids[game.ZielDrehung].ZDrehung + 2) < 2) && (game.asteroids[game.ZielSchuss].ZSumme > (game.asteroids[game.ZielDrehung].ZDrehung) + 2)) game.ZielSchuss = 99;
                        // if ((game.ZielAsteroidSF(game.ZielDrehung) == 14) && (game.SchüsseFrei(game.asteroids[game.ZielDrehung].ZDrehung + 2) < 2) && (game.asteroids[game.ZielSchuss].ZSumme > (game.asteroids[game.ZielDrehung].ZDrehung) + 2)) game.ZielSchuss = 99;
                    }
                    

                    SyncP = (game.SSync + 1); if (SyncP > 255) SyncP = 0;
                    SyncM = (game.SSync - 1); if (SyncM < 0) SyncM = 255;

                    if (game.ZielDrehung < 99)
                    {
                        Abweichung_W = game.Abweichung_W(game.ZielDrehung, game.SSync,game.Latenz);
                        AbweichungP_W = game.Abweichung_W(game.ZielDrehung, SyncP, game.Latenz);
                        AbweichungM_W = game.Abweichung_W(game.ZielDrehung, SyncM, game.Latenz);
                    }

                    if (game.HPause <= 0)
                    {
                       if (game.getroffen()) { keys.hyperspace(true); game.HPause = 4; }                                                     // Flucht, wenn Kollision unausweichlich
                    }
                    else game.HPause--;

                    if (((game.nasteroids > 0) || (game.saucer_present)) && (1==1) && (game.HPause!=4))
                    {
                        game.Auslastung = game.Auslastung + game.nshots_eigen; game.AuslastungZ++;

                        if (game.ZielDrehung < 0)
                        {
                            if ((Abweichung_W < 0) && (Math.Abs(AbweichungP_W) < Math.Abs(Abweichung_W))) { keys.right(true); game.AddSync = 1; }
                            if ((Abweichung_W > 0) && (Math.Abs(AbweichungM_W) < Math.Abs(Abweichung_W))) { keys.left(true); game.AddSync = -1; }
                        }
                        if ((game.ZielDrehung >= 0) && (game.ZielDrehung<99))
                        {
                            if ((game.asteroids[game.ZielDrehung].ForceLinks == false) && (game.asteroids[game.ZielDrehung].ForceRechts == false))
                            {
                                if ((Abweichung_W < 0) && (Math.Abs(AbweichungP_W) < Math.Abs(Abweichung_W))) { keys.right(true); game.AddSync = 1; }
                                if ((Abweichung_W > 0) && (Math.Abs(AbweichungM_W) < Math.Abs(Abweichung_W))) { keys.left(true); game.AddSync = -1; }
                            }
                            else
                            {
                                if (game.asteroids[game.ZielDrehung].ForceRechts == true) { keys.right(true); game.AddSync = 1; };
                                if (game.asteroids[game.ZielDrehung].ForceLinks == true)  { keys.left(true); game.AddSync = -1; };
                            }
                        }

                        if (game.pause == false)
                        {
                            if ((game.Schiffe < 50) && (game.ZielSchuss >= 0) && (game.ZielSchuss < 99)) // Ziel für Schuss ist ein Asteroid
                            {
                                keys.fire(true); game.pause = true; game.Schüsse++;
                                bool Schuss = false;
                                int AbweichungZ = game.asteroids[game.ZielSchuss].AbweichungZ;
                                if (AbweichungZ > 10) AbweichungZ = 10+(int)game.DLatenz;
                                if ((Schuss == false) && (game.asteroids[game.ZielSchuss].Schuss1 < 0)) { game.asteroids[game.ZielSchuss].Schuss1 = AbweichungZ; Schuss = true; }
                                if ((Schuss == false) && (game.asteroids[game.ZielSchuss].Schuss2 < 0)) { game.asteroids[game.ZielSchuss].Schuss2 = AbweichungZ; Schuss = true; }
                                if ((Schuss == false) && (game.asteroids[game.ZielSchuss].Schuss3 < 0)) { game.asteroids[game.ZielSchuss].Schuss3 = AbweichungZ; Schuss = true; }
                                if ((Schuss == false) && (game.asteroids[game.ZielSchuss].Schuss4 < 0)) { game.asteroids[game.ZielSchuss].Schuss4 = AbweichungZ; Schuss = true; }
                            }

                            if ((game.Schiffe < 50) && (game.ZielSchuss == -2))                         // Ziel für Schuss ist ein Ufo
                            {
                                int AbweichungZ = game.saucer.AbweichungZ;
                                if (AbweichungZ > 10) AbweichungZ = 10+(int)game.DLatenz;
                                keys.fire(true); game.pause = true; game.saucer.Schuss = AbweichungZ; game.Schüsse++;
                            }
                        }
                        else game.pause = false;
                    }  


                    if ((game.nasteroids == 0) && (game.saucer_present == false))
                    {
                        if ((game.ship_x==11524)&&(game.ship_y==11524))
                        {
                            if (game.WinkelDifferenz(0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) > 1) { keys.right(true); game.AddSync = 1; }
                            if (game.WinkelDifferenz(0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) < -1)  { keys.left(true); game.AddSync = -1; }
                        }

                        if (512 - Math.Abs(game.ship_x - 512) < 384 - Math.Abs(game.ship_y - 512))
                        {
                            if (game.ship_x < 512)
                            {
                                if (game.WinkelDifferenz(270, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) > 1) { keys.right(true); game.AddSync = 1; }
                                if (game.WinkelDifferenz(270, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) < -1) { keys.left(true); game.AddSync = -1; }
                            }

                            if (game.ship_x > 512)
                            {
                                if (game.WinkelDifferenz(90, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) > 1) { keys.right(true); game.AddSync = 1; }
                                if (game.WinkelDifferenz(90, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) < -1) { keys.left(true); game.AddSync = -1; }
                            }
                        }
                        else
                        {
                            if (game.ship_y < 512)
                            {
                                if (game.WinkelDifferenz(180, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) > 1) { keys.right(true); game.AddSync = 1; }
                                if (game.WinkelDifferenz(180, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) < -1) { keys.left(true); game.AddSync = -1; }
                            }

                            if (game.ship_y > 512)
                            {
                                if (game.WinkelDifferenz(0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) > 1) { keys.right(true); game.AddSync = 1; }
                                if (game.WinkelDifferenz(0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) < -1) { keys.left(true); game.AddSync = -1; }
                            }
                        }
                    }
                    Ausgabe(game);                      // Bildschirmausgabe
                }

                else game.pause = false;

                // if (game.AnzFrames == game.FrameLimit) { FileWrite.Main(System.DateTime.Now.ToString() + " Frames: " + game.AnzFrames.ToString("00000") + " Punkte: " + (game.Punkte + (game.HTPunkte * 100000)).ToString("00000000") + " Leben: " + game.Schiffe.ToString("00") + " Minleben: " + game.MinSchiffe.ToString("0") + " SprüngeA: " + game.JumpsA.ToString("00") + " SprüngeS: " + game.JumpsS.ToString("00") + " SprüngeU: " + game.JumpsU.ToString("00") + " Schüsse: " + game.Schüsse.ToString("0000") + " AL: " + ((int)(game.Auslastung * 2500 / 97) / game.AuslastungZ).ToString("000")+" LF: "+game.LostFrames.ToString("00000")+ " MaxL: "+game.MaxLatenz.ToString("0")+" AnzSyncErr: "+game.AnzSyncErr.ToString("00000")); game.AnzFrames++; }
                loop = 0;
            }
        }

        unsafe void InterpretScreen(FramePacket packet, GameStatus game)
        { 
            ushort[] vector_ram = packet.vectorram2;

            int dx;
            int dy;
            int sf;
            int vx = 0;
            int vy = 0, vz = 0, vs = 0;
            int v1x = 0;
            int v1y = 0;
            int shipdetect = 0;

            game.AltSchiffe = game.Schiffe;

            game.reset();
            if (packet.vectorram[1] != 0xe0 && packet.vectorram[1] != 0xe2)
                return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

            int pc = 1;
            for (; pc < 513; )
            {
                int op = vector_ram[pc] >> 12; ;
                switch (op)
                {
                    case 0xa: // LABS
                        vy = vector_ram[pc] & 0x3ff;
                        vx = vector_ram[pc + 1] & 0x3ff;
                        vs = vector_ram[pc + 1] >> 12;
                        break;
                    case 0xb: // HALT
                        return;
                    case 0xc: // JSRL
                        switch (vector_ram[pc] & 0xfff)
                        {
                            case 0x8f3:
                                game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
                                break;
                            case 0x8ff:
                                game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
                                break;
                            case 0x90d:
                                game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
                                break;
                            case 0x91a:
                                game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
                                break;
                            case 0x929:
                                game.saucer_present = true;
                                game.saucer_x = vx;
                                game.saucer_y = vy;
                                game.saucer_size = vs;
                                break;
                            case 0xB2E: // 1
                                if ((vy==876)&&(vx<480)) game.Punkte = (game.Punkte*10 + 1);
                                break;
                            case 0xB32: // 2
                                 if ((vy==876)&&(vx<480)) game.Punkte = (game.Punkte*10 + 2);
                                break;
                            case 0xB3A: // 3
                                if ((vy==876)&&(vx<480)) game.Punkte = (game.Punkte*10 + 3);
                                break;
                            case 0xB41: // 4
                                if ((vy==876)&&(vx<480)) game.Punkte = (game.Punkte*10 + 4);
                                break;
                            case 0xB48: // 5
                                if ((vy==876)&&(vx<480)) game.Punkte = (game.Punkte*10 + 5);
                                break;
                            case 0xB4F: // 6
                                if ((vy==876)&&(vx<480)) game.Punkte = (game.Punkte*10 + 6);
                                break;
                            case 0xB56: // 7
                                if ((vy==876)&&(vx<480)) game.Punkte = (game.Punkte*10 + 7);
                                break;
                            case 0xB5B: // 8
                                if ((vy==876)&&(vx<480)) game.Punkte = (game.Punkte*10 + 8);
                                break;
                            case 0xB63: // 9
                                if ((vy==876)&&(vx<480)) game.Punkte = (game.Punkte*10 + 9);
                                break;
                            case 0xADD: // 0
                                if ((vy==876)&&(vx<480)) game.Punkte = (game.Punkte*10 + 0);
                                break;
                            case 0xA6D: // Schiffe
                                game.Schiffe = game.Schiffe + 1;
                                break;
                        }
                        break;
                    case 0xd: // RTSL
                        return;
                    case 0xe: // JMPL
                        /*
                        pc = vector_ram[pc] & 0xfff;
                        break;
                        */
                        return;
                    case 0xf: // SVEC
                        /*
                        dy = vector_ram[pc] & 0x300;
                        if ((vector_ram[pc] & 0x400) != 0)
                            dy = -dy;
                        dx = (vector_ram[pc] & 3) << 8;
                        if ((vector_ram[pc] & 4) != 0)
                            dx = -dx;
                        sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
                        vz = (vector_ram[pc] & 0xf0) >> 4;
                        */
                        break;
                    default:
                        dy = vector_ram[pc] & 0x3ff;
                        if ((vector_ram[pc] & 0x400) != 0)
                            dy = -dy;
                        dx = vector_ram[pc + 1] & 0x3ff;
                        if ((vector_ram[pc + 1] & 0x400) != 0)
                            dx = -dx;
                        sf = op;
                        vz = vector_ram[pc + 1] >> 12;
                        if (dx == 0 && dy == 0 && vz == 15)
                            game.shots[game.nshots++].set(vx, vy);
                        if (op == 6 && vz == 12 && dx != 0 && dy != 0)
                        {
                            switch (shipdetect)
                            {
                                case 0:
                                    v1x = dx;
                                    v1y = dy;
                                    ++shipdetect;
                                    break;
                                case 1:
                                    game.ship_present = true;
                                    game.ship_x = vx;
                                    game.ship_y = vy;
                                    game.ship_dx = v1x - dx;
                                    game.ship_dy = v1y - dy;
                                    ++shipdetect;
                                    break;
                            }
                        }
                        else if (shipdetect == 1)
                            shipdetect = 0;

                        break;
                }
                if (op <= 0xa)
                    ++pc;
                if (op != 0xe) // JMPL
                    ++pc;
            }
        }

        public FramePacket ReceivePacket()
        {
            if (mySocket.Available == 0) return null;

            int received = 0;

            EndPoint myRemoteEndpoint = new IPEndPoint(server_ip, 1979);

            byte[] receiveBytes = new byte[mySocket.Available];

            try
            {
                received = mySocket.ReceiveFrom(receiveBytes, ref myRemoteEndpoint);
                ÜbertragungOK = true;
            }
            catch (Exception e)
            {
                ÜbertragungOK = false;
            }

            return FramePacket.FromByteArray(receiveBytes);
        }

        void SendPacket(KeysPacket packet)
        {
            byte[] bytCommand = packet.ToByteArray();
            int pret = mySocket.SendTo(bytCommand, bytCommand.Length, SocketFlags.None, new IPEndPoint(server_ip, 1979));
        }

        void SendPacketName(KeysPacket packet)
        {
            byte[] bytName = packet.ToByteArrayName();
            int pret = mySocket.SendTo(bytName, bytName.Length, SocketFlags.None, new IPEndPoint(server_ip, 1979));
        }

        void GameRunde(GameStatus game, KeysPacket keys)
        {
            if ((game.nasteroids == 0) && (game.saucer_present == false) && (1 == 0))
            {
                double w = game.Winkel(game.ship_x - 524, game.ship_y - 522);

                if (game.Runde == 2)
                {
                    if (game.WinkelDifferenz(213.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) < -1) { keys.left(true); game.AddSync = 1; }
                    if (game.WinkelDifferenz(213.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) > 1) { keys.right(true); game.AddSync = -1; }
                }

                if (game.Runde == 3)
                {
                    if (game.WinkelDifferenz(164.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) < -1) { keys.left(true); game.AddSync = 1; }
                    if (game.WinkelDifferenz(164.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) > 1) { keys.right(true); game.AddSync = -1; }
                }

                if (game.Runde == 4)
                {
                    if (game.WinkelDifferenz(115.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) < -1) { keys.left(true); game.AddSync = 1; }
                    if (game.WinkelDifferenz(115.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) > 1) { keys.right(true); game.AddSync = -1; }
                }

                if (game.Runde == 5)
                {
                    if (game.WinkelDifferenz(245.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) < -1) { keys.left(true); game.AddSync = 1; }
                    if (game.WinkelDifferenz(245.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) > 1) { keys.right(true); game.AddSync = -1; }
                }

                if (game.Runde == 6)
                {
                    if (game.WinkelDifferenz(311.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) < -1) { keys.left(true); game.AddSync = 1; }
                    if (game.WinkelDifferenz(311.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) > 1) { keys.right(true); game.AddSync = -1; }
                }

                if (game.Runde == 7)
                {
                    if (game.WinkelDifferenz(671.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) < -1) { keys.left(true); game.AddSync = 1; }
                    if (game.WinkelDifferenz(671.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) > 1) { keys.right(true); game.AddSync = -1; }
                }

                if (game.Runde == 8)
                {
                    if (game.WinkelDifferenz(264.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) < -1) { keys.left(true); game.AddSync = 1; }
                    if (game.WinkelDifferenz(264.0, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) > 1) { keys.right(true); game.AddSync = -1; }
                }

                if (game.Runde == 9)
                {
                    if (game.WinkelDifferenz((double)game.Test, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) < -1) { keys.left(true); game.AddSync = 1; }
                    if (game.WinkelDifferenz((double)game.Test, game.Winkel(game.SYNC.get_ship_dx(game.SSync), game.SYNC.get_ship_dy(game.SSync))) > 1) { keys.right(true); game.AddSync = -1; }
                }
            }

        }

        void Ausgabe_Init(GameStatus game)
        {
            Console.SetCursorPosition(1, 1); Console.WriteLine("Sekunden: 000000      Frame: 0000000      Punkte: 00000000        Punkte pro Frame: 0,000      Hochrechnung: 000000");

            Console.SetCursorPosition(1, 3); Console.WriteLine("Jumps Asteroid: 000");
            Console.SetCursorPosition(1, 4); Console.WriteLine("Jumps Schüsse:  000");
            Console.SetCursorPosition(1, 5); Console.WriteLine("Jumps Ufo:      000");

            Console.SetCursorPosition(23, 3); Console.WriteLine("Schiffe:      000");
            Console.SetCursorPosition(23, 4); Console.WriteLine("Lost Schiffe: 000");
            Console.SetCursorPosition(23, 5); Console.WriteLine("Max/Min:  000/000");

            Console.SetCursorPosition(43, 3); Console.WriteLine("Aktuelle Latenz:  000");
            Console.SetCursorPosition(43, 4); Console.WriteLine("verlorene Frames: 000");
            Console.SetCursorPosition(43, 5); Console.WriteLine("Anzahl Asteroids: 000");

            Console.SetCursorPosition(67, 3); Console.WriteLine("Maximale Latenz:  000            D-Latenz: 0,000");
            Console.SetCursorPosition(67, 4); Console.WriteLine("Max verl. Frames: 000         Lost Frames: 00000");
            Console.SetCursorPosition(67, 5); Console.WriteLine("Max A. Asteroids: 00              Schüsse: 00000");

            Console.SetCursorPosition(1, 8); Console.WriteLine(game.ship_x.ToString("0000") + " " + game.ship_y.ToString("0000") + " " + game.ship.dx.ToString("+0000;-0000") + " " + game.ship.dy.ToString("+0000;-0000") + " " + game.ship_dx.ToString("+0000;-0000") + " " + game.ship_dy.ToString("+0000;-0000") + " " + game.SSync.ToString("000") + " " + game.ship_present.ToString() + " ");
            Console.SetCursorPosition(1, 11); Console.WriteLine(game.saucer_x.ToString("0000") + " " + game.saucer_y.ToString("0000") + " " + game.saucer.dx.ToString("+0000;-0000") + " " + game.saucer.dy.ToString("+0000;-0000") + " " + game.saucer.AbstandMM.ToString("0000") + " " + game.saucer.AbstandH.ToString("0000") + " " + game.saucer_size.ToString("00") + " " + game.saucer.danger.ToString("0000") + " " + game.saucer.Schuss.ToString("00;-0") + " " + game.saucer.ZSumme.ToString("000") + " " + game.saucer.ZDrehung.ToString("00") + " " + game.saucer_present.ToString() + " ");

            Console.SetCursorPosition(93, 41); Console.Write(" ESync Synchron: " + game.Synchron.ToString() + " ");
            Console.SetCursorPosition(93, 43); Console.Write(" ESync Fehler:   " + game.AnzSyncErr.ToString("00000"));

            Console.SetCursorPosition(93, 45); Console.Write(" ESync vorher:   " + game.ESyncVorher.ToString("000"));
            Console.SetCursorPosition(93, 46); Console.Write(" ESync nachher:  " + game.ESync.ToString("000"));
            Console.SetCursorPosition(93, 47); Console.Write(" SSync Vorschau: " + game.SSync.ToString("000"));

            for (int i = 0; i < 26; i++)
            {
                Console.SetCursorPosition(1, 14 + i); Console.WriteLine("0000 0000 +0000 +0000 0000 0000 00 0000 0000 9999 -1 -1 -1 -1 0 0 000 000 000 000   ");
                Console.SetCursorPosition(85, 13 + i + 1); Console.WriteLine((i+1).ToString("00")+" 00000 000000 00 00 0,000 000");
            }

            Console.SetCursorPosition(83, 11); Console.WriteLine(" ");

            for (int i = 0; i < 6; i++)
            {
                Console.SetCursorPosition(1, 42 + i); if (game.shots[i].y == 0) Console.WriteLine("0000 0000 +000 +000 0000 0000 0000 0000 0000 0000 0000 0 0 00 00");
            }

            Console.SetCursorPosition(1, 49); Console.Write("IP-Adresse: " + server_ip.ToString());
            Console.SetCursorPosition(40, 49); Console.Write("Loop: ");

            Console.SetCursorPosition(1, 7); Console.WriteLine("SH_X SH_Y SH_DX SH_DY S_DRX S_DRY SYN");
            Console.SetCursorPosition(1, 10); Console.WriteLine("UF_X UF_Y UF_DX UF_DY A_MM AB_H SF DANG S1 ZSU DR");
            Console.SetCursorPosition(1, 13); Console.WriteLine("AS_X AS_Y AS_DX AS_DY A_MM AB_H SF ZYKL MABS DANG S1 S2 S3 S4 O L ABZ ZEN DRE ZSU");
            Console.SetCursorPosition(1, 41); Console.WriteLine("SH_X SH_Y S_DX S_DY A_MM ABST AB_H ZYKL MABS LIVE MLIV O E ZI ZZ");
            Console.SetCursorPosition(85, 13); Console.WriteLine("RU Frame Punkte LI JU DURCH AUS");
        }

        void Ausgabe(GameStatus game)
        {  
            double PunkteFrame=0;
            int LostSchiffe=0;

            if (game.AnzFrames > 0)
            {
                PunkteFrame = (game.Punkte + (game.HTPunkte * 100000.0)) / (double)game.AnzFrames;     // Punkte pro Sekunde
                LostSchiffe = (((game.Punkte + game.HTPunkte * 100000 )/ 10000) + 3)-game.Schiffe;
            }

            Console.SetCursorPosition(11, 1); Console.WriteLine(Sekunden.ToString("000000"));
            Console.SetCursorPosition(30, 1); Console.WriteLine(game.AnzFrames.ToString("0000000"));
            Console.SetCursorPosition(51, 1); Console.WriteLine(((game.Punkte) + (game.HTPunkte * 100000)).ToString("00000000"));
            Console.SetCursorPosition(85, 1); Console.WriteLine(PunkteFrame.ToString("f3"));
            Console.SetCursorPosition(110, 1); Console.WriteLine((PunkteFrame * 18000).ToString("000000"));

            Console.SetCursorPosition(17, 3); Console.WriteLine(game.JumpsA.ToString("000"));
            Console.SetCursorPosition(17, 4); Console.WriteLine(game.JumpsS.ToString("000"));
            Console.SetCursorPosition(17, 5); Console.WriteLine(game.JumpsU.ToString("000"));

            Console.SetCursorPosition(37, 3); Console.WriteLine(game.Schiffe.ToString("000"));
            Console.SetCursorPosition(37, 4); Console.WriteLine(LostSchiffe.ToString("000"));
            Console.SetCursorPosition(33, 5); Console.WriteLine(game.MaxSchiffe.ToString("000")+"/"+ game.MinSchiffe.ToString("000"));

            Console.SetCursorPosition(60, 3); Console.WriteLine(game.Latenz.ToString(" 000;-000"));
            Console.SetCursorPosition(60, 4); Console.WriteLine(game.Frames.ToString(" 000;-000"));
            Console.SetCursorPosition(60, 5); Console.WriteLine(game.nasteroids.ToString(" 00"));

            Console.SetCursorPosition(84, 3); Console.WriteLine(game.MaxLatenz.ToString(" 000;-000")); Console.SetCursorPosition(110, 3); Console.WriteLine(game.DLatenz.ToString("f3"));
            Console.SetCursorPosition(84, 4); Console.WriteLine(game.MaxFrames.ToString(" 000;-000")); Console.SetCursorPosition(110, 4); Console.WriteLine(game.LostFrames.ToString("00000"));
            Console.SetCursorPosition(84, 5); Console.WriteLine(game.MaxAsteroiden.ToString(" 00")); Console.SetCursorPosition(110, 5); Console.WriteLine(game.Schüsse.ToString("00000"));

            Console.SetCursorPosition(1, 8); Console.WriteLine(game.ship_x.ToString("0000") + " " + game.ship_y.ToString("0000") + " " + game.ship.dx.ToString("+0000;-0000") + " " + game.ship.dy.ToString("+0000;-0000") + " " + game.ship_dx.ToString("+0000;-0000") + " " + game.ship_dy.ToString("+0000;-0000") + " " + game.SSync.ToString("000") + " " + game.ship_present.ToString() + " ");
            Console.SetCursorPosition(1, 11); Console.WriteLine(game.saucer_x.ToString("0000") + " " + game.saucer_y.ToString("0000") + " " + game.saucer.dx.ToString("+0000;-0000") + " " + game.saucer.dy.ToString("+0000;-0000") + " " + game.saucer.AbstandMM.ToString("0000") + " " +game.saucer.AbstandH.ToString("0000")+ " "+game.saucer_size.ToString("00") + " " + game.saucer.danger.ToString("0000") + " " + game.saucer.Schuss.ToString("00;-0") + " "+game.saucer.ZSumme.ToString("000") + " " + game.saucer.ZDrehung.ToString("00") + " " + game.saucer_present.ToString() + " ");

            Console.SetCursorPosition(110, 41); Console.Write(game.Synchron.ToString() + " ");
            Console.SetCursorPosition(110, 43); Console.Write(game.AnzSyncErr.ToString("00000"));

            Console.SetCursorPosition(110, 45); Console.Write(game.ESyncVorher.ToString("000"));
            Console.SetCursorPosition(110, 46); Console.Write(game.ESync.ToString("000"));
            Console.SetCursorPosition(110, 47); Console.Write(game.SSync.ToString("000"));

            for (int i = 0; i < 26; i++)
            {
                Console.SetCursorPosition(1, 14 + i);
                if (game.asteroids[i].y == 0) Console.WriteLine("0000 0000 +0000 +0000 0000 0000 00 0000 0000 9999 -1 -1 -1 -1 0 0 000 000 000 000");
                else
                Console.WriteLine((game.asteroids[i].x).ToString("0000") + " " + (game.asteroids[i].y).ToString("0000") 
                          + " " + (game.asteroids[i].dx).ToString("+0000;-0000") + " " + (game.asteroids[i].dy).ToString("+0000;-0000") 
                          + " " + (game.asteroids[i].AbstandMM).ToString("0000") + " " + (game.asteroids[i].AbstandH).ToString("0000")
                          + " " + (game.asteroids[i].sf).ToString("00") + " " + (game.asteroids[i].Zyklen).ToString("0000") 
                          + " " + (game.asteroids[i].MinAbstand).ToString("0000") + " " + (game.asteroids[i].danger).ToString("0000") 
                          + " " + game.asteroids[i].Schuss1.ToString("00;-0") + " " + game.asteroids[i].Schuss2.ToString("00;-0") 
                          + " " + game.asteroids[i].Schuss3.ToString("00;-0") + " " + game.asteroids[i].Schuss4.ToString("00;-0") 
                          + " " + game.asteroids[i].ok.ToString("0") + " " + game.asteroids[i].Ziel_Lock.ToString("0")
                          + " " + game.asteroids[i].AbweichungZ.ToString("000") 
                          + " " + game.asteroids[i].ZEntfernung.ToString("000") + " " + game.asteroids[i].ZDrehung.ToString("000") + " " + game.asteroids[i].ZSumme.ToString("000")+" ");

                Console.SetCursorPosition(83, 14 + i); if (game.ZielDrehung == i) Console.WriteLine("*"); else Console.WriteLine(" ");
            }

            Console.SetCursorPosition(83, 11); if (game.ZielDrehung == -2) Console.WriteLine("*"); else Console.WriteLine(" ");


            for (int i = 0; i < 6; i++)
            {
                Console.SetCursorPosition(1, 42 + i);
                if (game.shots[i].y == 0) Console.WriteLine("0000 0000 +000 +000 0000 0000 0000 0000 0000 0000 0000 0 0 00 00");
                else
                Console.WriteLine(game.shots[i].x.ToString("0000") + " " + game.shots[i].y.ToString("0000") + " " + game.shots[i].dx.ToString("+000;-000")+ " " 
                    + game.shots[i].dy.ToString("+000;-000") +  " " + game.shots[i].AbstandMM.ToString("0000") + " " + game.shots[i].Abstand.ToString("0000") + " " 
                    + game.shots[i].AbstandH.ToString("0000") + " " + game.shots[i].Zyklen.ToString("0000") + " " + game.shots[i].MinAbstand.ToString("0000")+" " 
                    + game.shots[i].Zyklus.ToString("0000") + " " + game.shots[i].MaxZyklus.ToString("0000") + " " + game.shots[i].ok.ToString("0") + " " 
                    + game.shots[i].eigen.ToString("0") + " " + game.shots[i].Ziel.ToString("00;-0") + " " + game.shots[i].ZielZ.ToString("00"));
            }
        }

        void AusgabeFile(GameStatus game)
        {
            double PunkteFrame = 0;
            int LostSchiffe = 0;

            if (game.AnzFrames > 0)
            {
                PunkteFrame = (game.Punkte + (game.HTPunkte * 100000.0)) / (double)game.AnzFrames;     // Punkte pro Sekunde
                LostSchiffe = (((game.Punkte + game.HTPunkte * 100000) / 10000) + 3) - game.Schiffe;
            }

            FileWrite.Frame("Sekunden: " + Sekunden.ToString("000000") + "      Frame: " + game.AnzFrames.ToString("0000000") + "      Punkte: " + ((game.Punkte) + (game.HTPunkte * 100000)).ToString("00000000") + "        Punkte pro Frame: " + PunkteFrame.ToString("f3") + "      Hochrechnung: " + (PunkteFrame * 18000).ToString("000000"));
            FileWrite.Frame("Schiff:   " + game.ship_x.ToString("0000") + " " + game.ship_y.ToString("0000") + " " + game.ship.dx.ToString("+0000;-0000") + " " + game.ship.dy.ToString("+0000;-0000") + " " + game.ship_dx.ToString("+0000;-0000") + " " + game.ship_dy.ToString("+0000;-0000") + " " + game.SSync.ToString("000") + " " + game.ship_present.ToString() + " ");

            for (int i = 0; i < game.nasteroids; i++)
            {
                FileWrite.Frame((game.asteroids[i].x).ToString("0000") + " " + (game.asteroids[i].y).ToString("0000")
                          + " " + (game.asteroids[i].dx).ToString("+0000;-0000") + " " + (game.asteroids[i].dy).ToString("+0000;-0000")
                          + " " + (game.asteroids[i].AbstandMM).ToString("0000") + " " + (game.asteroids[i].AbstandH).ToString("0000")
                          + " " + (game.asteroids[i].sf).ToString("00") + " " + (game.asteroids[i].Zyklen).ToString("0000")
                          + " " + (game.asteroids[i].MinAbstand).ToString("0000") + " " + (game.asteroids[i].danger).ToString("0000")
                          + " " + game.asteroids[i].Schuss1.ToString("00;-0") + " " + game.asteroids[i].Schuss2.ToString("00;-0")
                          + " " + game.asteroids[i].Schuss3.ToString("00;-0") + " " + game.asteroids[i].Schuss4.ToString("00;-0")
                          + " " + game.asteroids[i].ok.ToString("0") + " " + game.asteroids[i].Ziel_Lock.ToString("00")
                          + " " + game.asteroids[i].AbweichungZ.ToString("000")
                          + " " + game.asteroids[i].ZEntfernung.ToString("000") + " " + game.asteroids[i].ZDrehung.ToString("00") + " " + game.asteroids[i].ZSumme.ToString("000") + " ");
            }

            for (int i = 0; i < game.nshots; i++)
            {
                FileWrite.Frame(game.shots[i].x.ToString("0000") + " " + game.shots[i].y.ToString("0000") + " " + game.shots[i].dx.ToString("+000;-000") + " "
                        + game.shots[i].dy.ToString("+000;-000") + " " + game.shots[i].AbstandMM.ToString("0000") + " " + game.shots[i].Abstand.ToString("0000") + " "
                        + game.shots[i].AbstandH.ToString("0000") + " " + game.shots[i].Zyklen.ToString("0000") + " " + game.shots[i].MinAbstand.ToString("0000") + " "
                        + game.shots[i].Zyklus.ToString("0000") + " " + game.shots[i].MaxZyklus.ToString("0000") + " " + game.shots[i].ok.ToString("0") + " "
                        + game.shots[i].eigen.ToString("0") + " " + game.shots[i].Ziel.ToString("00;-0") + " " + game.shots[i].ZielZ.ToString("00"));
            }

            FileWrite.Frame("");
        }
        
        void Ausgabe_Runde(GameStatus game)
        {
            double PunkteFrame=0;
            if (game.AnzFrames>120) PunkteFrame = (game.Punkte + (game.HTPunkte * 100000.0)) / (double)game.AnzFrames;     // Punkte pro Sekunde

            Console.SetCursorPosition(85, 13); Console.WriteLine("RU Frame Punkte LI JU DURCH AUS");

            if (game.AuslastungZ == 0) game.AuslastungZ = 1;

            if ((game.AnzFrames>120) && (game.AnzFrames!=game.AnzFramesOld))
            {
                if (game.Runde <= 26)
                {
                    Console.SetCursorPosition(85, 13 + game.Runde);
                    Console.WriteLine((game.Runde).ToString("00") + " " + (game.AnzFrames-game.AnzFramesOld).ToString("00000") + " " + ((game.Punkte) + (game.HTPunkte * 100000)).ToString("000000") + " " + (game.Schiffe).ToString("00") + " " + (game.JumpsA+game.JumpsS+game.JumpsU).ToString("00") + " " + PunkteFrame.ToString("f3")+" "+((int)(game.Auslastung*2500/97)/game.AuslastungZ).ToString("000"));
                    game.Runde++; game.AnzFramesOld = game.AnzFrames;
                }
            }
        }

        void Ausgabe_immer(GameStatus game)
        {
            Console.SetCursorPosition(46, 49); Console.Write(loop.ToString("00000"));
            
            Console.SetCursorPosition(90,49); if (ÜbertragungOK) Console.Write("    Übertragung in Ordnung");
            else
            {
                Console.Write(" Übertragung unterbrochen!"); game.run = false;
                Console.SetCursorPosition(70, 49); Console.Write("none     ");
            }
            
            Console.SetCursorPosition(70, 49); if (game.game_over)  Console.Write("game over");
            Console.SetCursorPosition(70, 49); if (game.busy)       Console.Write("busy     ");
            Console.SetCursorPosition(70, 49); if (game.run)        Console.Write("running  ");

            Console.SetCursorPosition(0, 0);

            game.game_over = false; game.busy = false; game.run = false;
       }

        void SendP()
        {

        // Send a series of key presses to the application.
        // Get a handle to the application. The window class
        // and window name were obtained using the Spy++ tool.

            IntPtr Handle = FindWindow("MAME", "MAME: Asteroids (rev 2) [asteroid]");

        // Verify that application is a running process.
        if (Handle == IntPtr.Zero) return;


        // Make application the foreground application and send it 

        SetForegroundWindow(Handle);
        SendKeys.SendWait("P");

        }

     }
   }
